/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.compiler;

import com.ibm.hwmca.fw.servlet.pmod.ModelConstants;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.LegacyResourceLookupInputSource;
import com.ibm.hwmca.fw.servlet.pmod.impl.NamespaceIndex;
import com.ibm.hwmca.fw.servlet.pmod.impl.PanelModelInputSource;
import com.ibm.hwmca.fw.servlet.pmod.impl.PanelModelParserElementHandler;
import com.ibm.hwmca.fw.servlet.pmod.impl.StackedInputStream;
import com.ibm.hwmca.fw.servlet.pmod.impl.StreamInputSource;
import com.ibm.hwmca.fw.servlet.pmod.impl.compiler.PanelCompiler;
import com.ibm.hwmca.fw.servlet.pmod.impl.compiler.SerializedPanel;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.DocumentRootNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.StopVisitException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Visitor;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParser;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParserFactory;
import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParserSourceImpl;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.util.TracingHandler;
import com.ibm.hwmca.fw.util.FastStack;
import com.ibm.hwmca.fw.util.auimlcvt.AUIMLParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class PanelCompiler {
    public static final String TRACE_MASK = "XPMCPCC";
    public static final String SERIALIZED_SUFFIX = "hmcser";
    private FastStack requests = new FastStack();
    private FastStack nodeStack = new FastStack();
    private NamespaceIndex namespaceIndex = null;
    private DocumentRootNode documentRoot = null;

    private static void useage() {
        System.out.println("java PanelCompiler sourceFile");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            PanelCompiler.useage();
        }
        new PanelModelTaskPortal(null, null);
        System.out.println("\n\nPanelCompiler begins processing file: " + args[0]);
        PanelCompiler pc = new PanelCompiler(args[0]);
        pc.compile();
        System.out.println("\nPanelCompiler completes processing file: " + args[0]);
        System.exit(0);
    }

    public PanelCompiler(String inputFileName) {
        try {
            String name;
            String directory;
            int i = inputFileName.lastIndexOf(File.separator);
            if (i == -1) {
                directory = ".";
                name = inputFileName;
            } else {
                directory = inputFileName.substring(0, i);
                name = inputFileName.substring(i + 1);
            }
            if (name.endsWith(".hmcml")) {
                this.requests.push(new SerRequest(new StreamInputSource(new BufferedInputStream(new FileInputStream(inputFileName))), directory, name.substring(0, name.lastIndexOf(".hmcml"))));
            } else if (name.endsWith(".auiml")) {
                AUIMLParser ap = new AUIMLParser(inputFileName.substring(0, inputFileName.lastIndexOf(".auiml")));
                String[] dataGroups = ap.findDataGroupNames();
                int j = 0;
                while (j < dataGroups.length) {
                    this.requests.push(new SerRequest(new LegacyResourceLookupInputSource(inputFileName.substring(0, inputFileName.lastIndexOf(".auiml")).replace('/', '.'), new Locale[]{Locale.getDefault()}, dataGroups[j]), directory, name.substring(0, name.lastIndexOf(".auiml")) + "$" + dataGroups[j]));
                    ++j;
                }
            } else {
                System.err.println("PanelCompiler: Encountered file that can not be handled.  Only '.auiml' and '.hmcml' can be processed.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println("PanelCompiler: IOException creating stream using: '" + inputFileName + "'");
        }
    }

    public void compile() {
        while (!this.requests.empty()) {
            SerRequest request = (SerRequest)this.requests.pop();
            this.namespaceIndex = new NamespaceIndex();
            this.documentRoot = null;
            System.out.println("\nPanelCompiler.compile(): processing request: " + request.name);
            this.parse(request.inputSource);
            try {
                class MyVisitor
                extends Visitor {
                    private int depth;
                    private final /* synthetic */ PanelCompiler this$0;

                    MyVisitor(PanelCompiler this$0) {
                        this.this$0 = this$0;
                        this.depth = 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void visit(Node node, MyVisitor visitor) throws PanelModelException {
                        if (node != null) {
                            node.visit(visitor);
                            List list = node.getChildren();
                            if (!(list instanceof ModelConstants.PmEmptyList)) {
                                Iterator<E> iterator = ((List)((ArrayList)list).clone()).iterator();
                                Node next = null;
                                while (iterator.hasNext()) {
                                    Object var8_7;
                                    try {
                                        try {
                                            this.deeper();
                                            next = (Node)iterator.next();
                                            this.visit(next, visitor);
                                        }
                                        catch (StopVisitException e) {
                                            var8_7 = null;
                                            this.unvisit(next);
                                            this.shallower();
                                            continue;
                                        }
                                        var8_7 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var8_7 = null;
                                        this.unvisit(next);
                                        this.shallower();
                                        throw throwable;
                                    }
                                    this.unvisit(next);
                                    this.shallower();
                                }
                            }
                        }
                    }

                    private void deeper() {
                        ++this.depth;
                    }

                    private void shallower() {
                        --this.depth;
                    }

                    public void unvisit(Node node) throws PanelModelException {
                        System.out.println(TracingHandler.indent(this.depth) + "</" + node.getFullName() + ">");
                    }

                    public void common(Node node) throws PanelModelException {
                        System.out.println(TracingHandler.indent(this.depth) + node);
                    }
                }
                MyVisitor myVisitor = new MyVisitor(this);
                System.out.println("PanelCompiler.compile(): Tracing document contents");
                myVisitor.visit(this.documentRoot, myVisitor);
            }
            catch (PanelModelException e) {
                e.printStackTrace();
            }
            try {
                String outputFile = request.dir + File.separator + request.name + "." + SERIALIZED_SUFFIX;
                System.out.println("PanelCompiler.compile(): writing: " + outputFile);
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outputFile));
                oos.writeObject(new SerializedPanel(this.namespaceIndex, this.documentRoot));
                oos.close();
            }
            catch (IOException e) {
                System.err.println("PanelCompiler.compile() IOException writing file: " + e);
            }
            System.out.println("*** Done ***");
        }
    }

    private boolean parse(PanelModelInputSource inputSource) {
        try {
            InputStream documentInputStream = inputSource.getInputStream();
            ModelParser parser = ModelParserFactory.getParser();
            StackedInputStream stackedInputStream = new StackedInputStream();
            int modelAddedFrontMatter = this.formParseStream(stackedInputStream, documentInputStream, "*", "*", "*");
            ModelParserSourceImpl source = new ModelParserSourceImpl(stackedInputStream, modelAddedFrontMatter);
            PanelModelParserElementHandler handler = new PanelModelParserElementHandler(null, inputSource, source, this.nodeStack, this.namespaceIndex);
            parser.setHandler(handler);
            System.out.println("parse() invoking parse impl.");
            parser.parse(source);
            handler.checkException();
            this.documentRoot = handler.getDocumentRoot();
        }
        catch (Exception e) {
            System.err.println("Exception during parse()." + e.getMessage());
            e.printStackTrace();
            return false;
        }
        System.out.println("parse() completes normally.");
        return true;
    }

    private int formParseStream(StackedInputStream stackedInputStream, InputStream documentInputStream, String wcl_objectScope, String wcl_objectScopeId, String fmtBundleBaseName) throws PanelModelException {
        boolean includeFmtBundle = fmtBundleBaseName != null && !"".equals(fmtBundleBaseName);
        int modelAddedFrontMatter = 0;
        stackedInputStream.push(new ByteArrayInputStream(PanelModel.HMC_CONTEXT_TERMINATOR));
        if (includeFmtBundle) {
            stackedInputStream.push(new ByteArrayInputStream(PanelModel.FMT_BUNDLE_TERMINATOR));
        }
        stackedInputStream.push(new ByteArrayInputStream(PanelModel.WCL_FOUNDATION_TERMINATOR));
        stackedInputStream.push(new ByteArrayInputStream(PanelModel.WCL_CONTAINER_TERMINATOR));
        stackedInputStream.push(new BufferedInputStream(documentInputStream, 8192));
        stackedInputStream.push(new ByteArrayInputStream(PanelModel.WCL_CONTAINER_LEADER));
        modelAddedFrontMatter += PanelModel.WCL_CONTAINER_LEADER.length;
        byte[] fndLeader = ("\n<wcl:Foundation objectScope=\"" + wcl_objectScope + "\" objectScopeId=\"" + wcl_objectScopeId + "\">").getBytes();
        modelAddedFrontMatter += fndLeader.length;
        stackedInputStream.push(new ByteArrayInputStream(fndLeader));
        if (includeFmtBundle) {
            byte[] fmtLeader = ("\n<fmt:bundle basename=\"" + fmtBundleBaseName + "\">").getBytes();
            modelAddedFrontMatter += fmtLeader.length;
            stackedInputStream.push(new ByteArrayInputStream(fmtLeader));
        }
        byte[] hmcLeader = "\n<hmc:context modelID=\"*\">".getBytes();
        modelAddedFrontMatter += hmcLeader.length;
        stackedInputStream.push(new ByteArrayInputStream(hmcLeader));
        if (PanelModel.obligatoryDocumentFrontContent != null) {
            byte[] oblig = "</pmod:ObligFrontMatter>".getBytes();
            modelAddedFrontMatter += oblig.length;
            stackedInputStream.push(new ByteArrayInputStream(oblig));
            modelAddedFrontMatter += PanelModel.obligatoryDocumentFrontContent.length;
            stackedInputStream.push(new ByteArrayInputStream(PanelModel.obligatoryDocumentFrontContent));
            oblig = "<pmod:ObligFrontMatter>".getBytes();
            modelAddedFrontMatter += oblig.length;
            stackedInputStream.push(new ByteArrayInputStream(oblig));
        }
        return modelAddedFrontMatter;
    }

    private static class SerRequest {
        PanelModelInputSource inputSource;
        String name;
        String dir;

        SerRequest(PanelModelInputSource inputSource, String dir, String name) {
            this.inputSource = inputSource;
            this.dir = dir;
            this.name = name;
        }
    }
}

